/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.


////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
#include <Array.h>  // need to include this header
class POINTEX
{
public:
	POINTEX(int n)
	{
		m_n = n;
		printf("Constructor\n");
	}
	
	~POINTEX()
	{
		printf("Destructor, n = %d\n", m_n);
	}
	
	int m_n;
};

void testOK()
{
	Array<POINTEX&> myArray(true);
	ASSERT(myArray.IsOwner()); //==> assert failed here
	
	//--> works fine
	//Array<POINTEX&> myArray; 
	//myArray.SetAsOwner(true);	
}

static void _perpare_array(Array<POINTEX&> &myArray)
{	
	// Add elements to the array.
	int		ii;
	int		nSize = 3;
	for(ii = 0; ii < nSize; ii++)
	{		
		POINTEX		*pp = new POINTEX(ii+1);
		myArray.Add(*pp);
	}	
}
void Array_remove_one_item(int nToRemove = 0)
{
	Array<POINTEX&> myArray;
	myArray.SetAsOwner(true);
	_perpare_array(myArray);	
	
	POINTEX		*pEmpty = NULL;	
	myArray.SetAt(nToRemove, *pEmpty);
}


typedef struct tagSTPOINT
{
	int x;
	int y;
}STPOINT;

void struct_array()
{
	Array<STPOINT&> myArray;
	myArray.SetAsOwner(true);
	
	int nSize = 3;
	for(int ii = 0; ii< nSize; ii++)
	{
		STPOINT		*pp = new STPOINT;
		pp->x = ii;
		pp->y = ii;
		myArray.Add(*pp);
	}

	for(ii = 0; ii< nSize; ii++)
	{
		STPOINT&	st = myArray.GetAt(ii);
		printf("%d\tx=%d\ty=%d\n", ii, st.x, st.y);
	}	
}